package com.qboxus.tictic.activitesfragments.shoping.adapter

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.databinding.DataBindingUtil
import androidx.recyclerview.widget.RecyclerView
import com.qboxus.tictic.Constants
import com.qboxus.tictic.R
import com.qboxus.tictic.activitesfragments.shoping.models.OrderHistoryModel
import com.qboxus.tictic.activitesfragments.shoping.models.OrderProduct
import com.qboxus.tictic.databinding.ItemOrderDetailBinding
import com.qboxus.tictic.interfaces.AdapterClickListener
import com.qboxus.tictic.simpleclasses.Functions.frescoImageLoad


class OrderDetailAdapter(
    var context: Context,
    var model: OrderHistoryModel,
    var dataList: ArrayList<OrderProduct>,
    var adapterClickListener: AdapterClickListener
) : RecyclerView.Adapter<OrderDetailAdapter.CustomViewHolder>() {
    override fun onCreateViewHolder(parent: ViewGroup, viewtype: Int): CustomViewHolder {
        val binding = DataBindingUtil.inflate<ItemOrderDetailBinding>(
            LayoutInflater.from(parent.context),
            R.layout.item_order_detail,
            parent,
            false
        )
        return CustomViewHolder(binding)
    }

    override fun onBindViewHolder(holder: CustomViewHolder, position: Int) {
        val item = dataList[position]

        holder.binding.orderImage.controller =
            frescoImageLoad(
                item.product_image,
                R.drawable.image_placeholder,
                holder.binding.orderImage,
                false
            )

        holder.binding.orderDetailPrice.text = Constants.productShowingCurrency + item.product_price
        holder.binding.orderDetailTitle.text = item.product_title
        holder.binding.orderDetailQuantity.text = item.product_quantity
        holder.binding.orderDetailSize.text = item.product_attritube_combination_id


        if (model.order.status == "2") {
            holder.binding.ratingbar.visibility = View.VISIBLE
        } else {
            holder.binding.ratingbar.visibility = View.GONE
        }

        if (item.productRating != null) {
            holder.binding.ratingbar.rating = item.productRating.star.toInt().toFloat()
        }

        holder.bind(position, item, adapterClickListener)
    }

    override fun getItemCount(): Int {
        return dataList.size
    }

    inner class CustomViewHolder(var binding: ItemOrderDetailBinding) : RecyclerView.ViewHolder(
        binding.root
    ) {
        fun bind(position: Int, item: OrderProduct?, listener: AdapterClickListener) {
            binding.ratingLayout.setOnClickListener { v: View? ->
                listener.onItemClick(v, position, item)
            }
        }
    }
}